/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import junit.framework.TestCase;
import org.python.core.PySystemState;

public class PySystemState_registry_Test
extends TestCase {
    private static final String REGISTRY = "registry";
    private static final String USER_REGISTRY = ".jython";
    private static final String DIST = "dist";
    private static final String FIRST_PROP = "first.test.property";
    private static final String SECOND_PROP = "second.test.property";
    private static final String USER_HOME = "user.home";
    private static final String PYTHON_HOME = "python.home";
    private static final String ANY = "any";
    private static final String PRE = "pre";
    private static final String POST = "post";
    private static final String INSTALLED = "installed";
    private static final String USER = "user";
    private String _originalUserHome;
    private File _root;
    private String _originalRegistryContent;
    private Properties _originalRegistry;
    private File _tmpDir;

    protected void setUp() throws Exception {
        this.findRoot();
        this.storeOriginals();
        this.uninitialize();
    }

    protected void tearDown() throws Exception {
        this.restoreOriginals();
        this.cleanup();
    }

    public void testInitialize_PrePostProperties() throws Exception {
        Properties properties = this.createPreProperties();
        properties.setProperty(FIRST_PROP, PRE);
        properties.setProperty(SECOND_PROP, PRE);
        Properties properties2 = this.createPostProperties();
        properties2.setProperty(SECOND_PROP, POST);
        PySystemState.initialize(properties, properties2);
        Properties properties3 = PySystemState.registry;
        String string = properties3.getProperty(FIRST_PROP, ANY);
        String string2 = properties3.getProperty(SECOND_PROP, ANY);
        PySystemState_registry_Test.assertEquals((String)PRE, (String)string);
        PySystemState_registry_Test.assertEquals((String)POST, (String)string2);
    }

    public void testInitialize_Registry_User() throws Exception {
        String string = FIRST_PROP.concat("=").concat(INSTALLED);
        this.appendToInstalledRegistry(string);
        String string2 = FIRST_PROP.concat("=").concat(USER);
        this.addUserRegistry(string2);
        Properties properties = this.createPreProperties();
        Properties properties2 = this.createPostProperties();
        PySystemState.initialize(properties, properties2);
        Properties properties3 = PySystemState.registry;
        String string3 = properties3.getProperty(FIRST_PROP, ANY);
        PySystemState_registry_Test.assertEquals((String)USER, (String)string3);
    }

    public void testInitialize_Pre_Registries() throws Exception {
        String string = FIRST_PROP.concat("=").concat(INSTALLED);
        this.appendToInstalledRegistry(string);
        String string2 = FIRST_PROP.concat("=").concat(USER);
        this.addUserRegistry(string2);
        Properties properties = this.createPreProperties();
        properties.setProperty(FIRST_PROP, PRE);
        Properties properties2 = this.createPostProperties();
        PySystemState.initialize(properties, properties2);
        Properties properties3 = PySystemState.registry;
        String string3 = properties3.getProperty(FIRST_PROP, ANY);
        PySystemState_registry_Test.assertEquals((String)PRE, (String)string3);
    }

    public void testInitialize_Post_Registries() throws Exception {
        String string = FIRST_PROP.concat("=").concat(INSTALLED);
        this.appendToInstalledRegistry(string);
        String string2 = FIRST_PROP.concat("=").concat(USER);
        this.addUserRegistry(string2);
        Properties properties = this.createPreProperties();
        properties.setProperty(FIRST_PROP, PRE);
        Properties properties2 = this.createPostProperties();
        properties2.setProperty(FIRST_PROP, POST);
        PySystemState.initialize(properties, properties2);
        Properties properties3 = PySystemState.registry;
        String string3 = properties3.getProperty(FIRST_PROP, ANY);
        PySystemState_registry_Test.assertEquals((String)POST, (String)string3);
    }

    private void findRoot() throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String string = "/".concat(clazz.getName().replace('.', '/')).concat(".class");
        URL uRL = clazz.getResource(string);
        PySystemState_registry_Test.assertNotNull((Object)uRL);
        String string2 = URLDecoder.decode(uRL.getPath(), "UTF-8");
        PySystemState_registry_Test.assertTrue((boolean)string2.endsWith(string));
        String string3 = string2.substring(0, string2.length() - string.length());
        File file = new File(string3);
        PySystemState_registry_Test.assertTrue((boolean)file.exists());
        PySystemState_registry_Test.assertTrue((boolean)file.isDirectory());
        this._root = new File(file.getParentFile().getParentFile(), DIST);
        PySystemState_registry_Test.assertTrue((boolean)this._root.exists());
        PySystemState_registry_Test.assertTrue((boolean)this._root.isDirectory());
    }

    private void uninitialize() throws Exception {
        Field field = PySystemState.class.getDeclaredField("initialized");
        field.setAccessible(true);
        field.set(null, false);
        PySystemState.registry = null;
    }

    private void storeOriginals() throws Exception {
        this._originalRegistry = PySystemState.registry;
        this._originalUserHome = System.getProperty(USER_HOME);
        File file = new File(this.getRoot(), REGISTRY);
        PySystemState_registry_Test.assertTrue((boolean)file.exists());
        this._originalRegistryContent = this.readAll(file);
    }

    private void restoreOriginals() throws Exception {
        PySystemState.registry = this._originalRegistry;
        String string = this.getOriginalUserHome();
        if (string != null) {
            System.setProperty(USER_HOME, string);
        }
        this.writeInstalledRegistry(this.getOriginalRegistryContent());
    }

    private void writeInstalledRegistry(String string) throws IOException {
        if (string != null && string.length() > 0) {
            File file = new File(this.getRoot(), REGISTRY);
            PySystemState_registry_Test.assertTrue((boolean)file.exists());
            this.write(file, string);
        }
    }

    private void appendToInstalledRegistry(String string) throws IOException {
        if (string != null && string.length() > 0) {
            String string2 = this.getOriginalRegistryContent().concat(string);
            this.writeInstalledRegistry(string2);
        }
    }

    private void addUserRegistry(String string) throws Exception {
        File file = this.createTempDir();
        System.setProperty(USER_HOME, file.getCanonicalPath());
        File file2 = new File(file, USER_REGISTRY);
        this.write(file2, string);
        PySystemState_registry_Test.assertTrue((boolean)file2.exists());
        PySystemState_registry_Test.assertTrue((boolean)file2.isFile());
    }

    private Properties createPreProperties() {
        return new Properties(System.getProperties());
    }

    private Properties createPostProperties() throws Exception {
        Properties properties = new Properties();
        properties.setProperty(PYTHON_HOME, this.getRoot().getCanonicalPath());
        return properties;
    }

    private File createTempDir() throws Exception {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        File file = File.createTempFile(string, "");
        PySystemState_registry_Test.assertTrue((boolean)file.exists());
        PySystemState_registry_Test.assertTrue((boolean)file.isFile());
        File file2 = file.getParentFile();
        PySystemState_registry_Test.assertTrue((boolean)file2.exists());
        PySystemState_registry_Test.assertTrue((boolean)file2.isDirectory());
        PySystemState_registry_Test.assertTrue((boolean)file.delete());
        File file3 = new File(file2, string);
        PySystemState_registry_Test.assertTrue((boolean)file3.mkdir());
        PySystemState_registry_Test.assertTrue((boolean)file3.exists());
        PySystemState_registry_Test.assertTrue((boolean)file3.isDirectory());
        this._tmpDir = file3;
        return file3;
    }

    private void cleanup() {
        File file = this.getTmpDir();
        if (file != null && file.exists()) {
            PySystemState_registry_Test.assertTrue((boolean)this.rmdir(file));
        }
        this._tmpDir = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAll(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[8192];
            while ((n = fileReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            fileReader.close();
        }
    }

    private void write(File file, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.flush();
        fileWriter.close();
    }

    private boolean rmdir(File file) {
        boolean bl = true;
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isFile()) {
                    bl = this.carryOnResult(file2.delete(), bl);
                    continue;
                }
                if (!file2.isDirectory()) continue;
                bl = this.carryOnResult(this.rmdir(file2), bl);
            }
            bl = this.carryOnResult(file.delete(), bl);
        }
        return bl;
    }

    private boolean carryOnResult(boolean bl, boolean bl2) {
        if (bl2) {
            return bl;
        }
        return bl2;
    }

    private File getRoot() {
        return this._root;
    }

    private File getTmpDir() {
        return this._tmpDir;
    }

    private String getOriginalUserHome() {
        return this._originalUserHome;
    }

    private String getOriginalRegistryContent() {
        return this._originalRegistryContent;
    }
}

